/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import mod.chiselsandbits.platforms.core.client.models.vertices.IVertexConsumer;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_777;

public final class LightUtil {
    private LightUtil() {
        throw new IllegalStateException("Tried to construct a LightUtil instance, but this is a utility class!");
    }

    public static void pack(float[] from, int[] to, class_293 formatTo, int v, int e) {
        class_296 element = (class_296)formatTo.method_1357().get(e);
        int vertexStart = v * formatTo.method_1362() + formatTo.field_1597.getInt(e);
        int count = element.method_34451();
        class_296.class_297 type = element.method_1386();
        int size = type.method_1391();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < 4; ++i) {
            float f;
            if (i >= count) continue;
            int pos = vertexStart + size * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i < from.length ? from[i] : 0.0f;
            bits = type == class_296.class_297.field_1623 ? Float.floatToRawIntBits(f) : (type == class_296.class_297.field_1624 || type == class_296.class_297.field_1622 || type == class_296.class_297.field_1619 ? Math.round(f * (float)mask) : Math.round(f * (float)(mask >> 1)));
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    public static void put(IVertexConsumer consumer, class_777 quad) {
        consumer.setTexture(quad.method_35788());
        consumer.setQuadOrientation(quad.method_3358());
        if (quad.method_3360()) {
            consumer.setQuadTint(quad.method_3359());
        }
        consumer.setApplyDiffuseLighting(quad.method_24874());
        float[] data = new float[4];
        class_293 format = class_290.field_1590;
        int elementCount = format.method_1357().size();
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < elementCount; ++e) {
                LightUtil.unpack(quad.method_3357(), data, format, v, e);
                consumer.put(e, data);
            }
        }
    }

    public static void unpack(int[] from, float[] to, class_293 formatFrom, int v, int e) {
        int length = Math.min(4, to.length);
        class_296 element = (class_296)formatFrom.method_1357().get(e);
        int vertexStart = v * formatFrom.method_1362() + formatFrom.field_1597.getInt(e);
        int count = element.method_34451();
        class_296.class_297 type = element.method_1386();
        class_296.class_298 usage = element.method_1382();
        int size = type.method_1391();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == class_296.class_297.field_1623) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == class_296.class_297.field_1624 || type == class_296.class_297.field_1622) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == class_296.class_297.field_1619) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == class_296.class_297.field_1621) {
                    to[i] = (float)((byte)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type == class_296.class_297.field_1625) {
                    to[i] = (float)((short)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type != class_296.class_297.field_1617) continue;
                to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                continue;
            }
            to[i] = i == 3 && usage == class_296.class_298.field_1633 ? 1.0f : 0.0f;
        }
    }

    public static float diffuseLight(class_2350 side) {
        return switch (side) {
            case class_2350.field_11033 -> 0.5f;
            case class_2350.field_11036 -> 1.0f;
            case class_2350.field_11043, class_2350.field_11035 -> 0.8f;
            default -> 0.6f;
        };
    }
}

